/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.tasks.Task;

public class RawTaskStatus
implements Task.Status {
    public static final String NAME = "raw";
    private final BytesReference status;

    public RawTaskStatus(BytesReference status) {
        this.status = Objects.requireNonNull(status, "status may not be null");
    }

    public RawTaskStatus(StreamInput in) throws IOException {
        this.status = in.readOptionalBytesReference();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBytesReference(this.status);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        try (StreamInput stream = this.status.streamInput();){
            XContentBuilder xContentBuilder = builder.rawValue((InputStream)stream, MediaTypeRegistry.xContentType((BytesReference)this.status));
            return xContentBuilder;
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public Map<String, Object> toMap() {
        return (Map)XContentHelper.convertToMap(this.status, false).v2();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RawTaskStatus.class) {
            return false;
        }
        RawTaskStatus other = (RawTaskStatus)obj;
        return this.toMap().equals(other.toMap());
    }

    public int hashCode() {
        return this.toMap().hashCode();
    }
}

